/*
 * Framework.h
 *
 *  Created on: Aug 17, 2012
 *      Author: linh
 */

#ifndef FRAMEWORK_H_
#define FRAMEWORK_H_

#include "VFLIB/ull_sub_state.h"
#include "VFLIB/vf2_sub_state.h"
#include "VFLIB/match.h"
#include "VFLIB/argedit.h"
#include "DesignProblem.h"
#include "PartDatabase.h"
#include "GeneCircuitGraph.h"
#include "DynamicGeneCircuit.h"

struct NodePair {
	NodePair(node_id n1, node_id n2) {
		small_graph_node = n1;
		large_graph_node = n2;
	}
	node_id small_graph_node;
	node_id large_graph_node;
};

struct Link {
	Link (int src_, int dest_) {
		src = src_;
		dest = dest_;
	}
	int src;
	int dest;
};

typedef vector<NodePair> GraphIsomorphism;
typedef vector<GraphIsomorphism> GraphIsomorphismCollection;
typedef vector<Link> ListOfLinks;

bool all_visitor(int n, node_id* small_graph_node_list, node_id* large_graph_node_list, void* all_graph_isomorphism);

class Matching_State {
public:
	Matching_State() {
		// Do nothing
	}
	Matching_State(GeneCircuitGraph* gcg_, int module_id_, GraphIsomorphismCollection* matching_list_, int matching_id_): gcg(gcg_),
		module_id(module_id_),
		matching_list(matching_list_),
		matching_id(matching_id_){
		// Do nothing
	}

	GeneCircuitGraph* gcg;
	int module_id;
	GraphIsomorphismCollection *matching_list;
	int matching_id;
};

class Framework {
public:
	Framework();
	Framework(PartDatabase* partDB_);
	Framework(PartDatabase* partDB_, DesignProblem dp_);
	virtual ~Framework();
	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* ModuleMatch(int number_of_solution, int synthetic_module_library_size, int number_of_DB_replicates = 1);
	void Optimize();
	void Scalability(int number_of_gates, int number_of_inputs, int number_of_DB_replicates, int module_library_size, int number_of_solutions);

	double getRunningTime() {
		return running_time;
	}
	void ResetRunningTime() {
		running_time = 0;
	}
	void addRunningTime(double extra_time) {
		running_time += extra_time;
	}

	PartDatabase* partDB;
	DesignProblem dp;

private:
	double running_time;
};

int Find_Regulation(GeneCircuitComponent* src, GeneCircuitComponent* dest, PartDatabase *partDB);
bool Check_Update(GeneCircuitGraph *gcg, int src_node, int dest_node, PartDatabase *partDB);
GeneCircuitGraph* Layout(GeneCircuitGraph *gcg, PartDatabase* partDB);
GeneCircuitGraph* GeneCircuitGraphExtension(GeneCircuitGraph* gcg, int sub_node_id, Module* module, PartDatabase *partDB);

#endif /* FRAMEWORK_H_ */
